function [SummaryOutput]=calculate_output(SIMULATION,Outputs);

% calculate-output calculates for each simulation a matrix with summary output.
% SIMULATION is a string that names the sim, Outputs the matrix from which
% the summary is to be calculated. Structure of this matrix is assumed to
% be known for each sim (see generate_ec_inputs to see).

if strcmp(SIMULATION,'famil')
  text = 'Fst row gives response to ctxt over time, scnd row response to stim'
  N_TIME = size(Outputs,1);  
  N_CTXT = round(size(Outputs,2)*0.5);
  N_STIM = 3;

  % Here definition of output. Each row one condition.
  SummaryOutput(:,1) = mean(Outputs(1:20,1:N_CTXT),2);
  SummaryOutput(:,2) = mean(Outputs(N_TIME-19:N_TIME, 1:N_CTXT),2);
  SummaryOutput(:,3) = mean(Outputs(1:20, N_CTXT+1:N_CTXT+N_STIM),2);
  SummaryOutput(:,4) = mean(Outputs(N_TIME-19:N_TIME,N_CTXT+1:N_CTXT+N_STIM),2);
  SummaryOutput=SummaryOutput'; % ' is 'transpose'
  plot(1:size(SummaryOutput,2),SummaryOutput);
%  legend('fst presentation','scnd presentation');
  legend('context-start','context-end','stim-pres.1','stim-pres.2');
  ylabel('av. firing');
  xlabel('time steps');
  save ECMODEL/results/res-famil.txt SummaryOutput -ASCII -TABS;
end

if strcmp(SIMULATION,'recall')
  %SummaryOutput(:,1) = mean(Outputs(1:20,:),2);
  %SummaryOutput(:,2) = mean(Outputs(21:40,:),2);
  SummaryOutput(:,1) = Outputs(1,:)';
  SummaryOutput(:,2) = Outputs(19,:)';
  SummaryOutput(:,3) = Outputs(35,:)';
  SummaryOutput(:,4) = Outputs(39,:)';
  Summaryoutput=SummaryOutput'; % ' is 'transpose'
  plot(1:size(SummaryOutput,1),SummaryOutput);
  legend('ctxt','ctxt-pres.2', 'stim-end','ctxt-end');
  ylabel('av. firing');
  xlabel('time steps');
  save ECMODEL/results/res-recall.txt SummaryOutput -ASCII -TABS;
end

if strcmp(SIMULATION,'discrim')
  SummaryOutput = Outputs'; %' No calculations needed
  plot(1:size(SummaryOutput,2),SummaryOutput);
  legend('airpuff','signal');
  ylabel('av. firing');
  xlabel('time steps');
  save ECMODEL/results/res-outp.txt SummaryOutput -ASCII -TABS;
end

%[X,Y] = meshgrid(1:4, 1:20);
%mesh(X,Y,ResultSummary, 'EdgeColor', 'black');
