function [x]=complex_output(SIMUL,Inputs,EC_Outp,HIP_Outp,CER_Outp,LYR);
% complex-output calculates for each simulation several outputs.
% SIMUL is a string that names the sim, Outputs the matrix from which
% the summary is to be calculated. Structure of this matrix is assumed to
% be known for each sim (see generate_ec_inputs to see).

LargeTimeScale = 0;

LookAtCerOutcome=0;
LookAtLayerOutputs=1;
LookAtEndEC=0;
LookAtHippPattern=0;
LookAtEndHip=0;

N_CtxtInEC = 15;
N_StimInEC = 1;

if(LookAtCerOutcome==1)
  if(LargeTimeScale==1)
    Performance = takeoutstimcontrol(Inputs,CER_Outp'); % 'transpose
  else
    if(size(Inputs,1)>499)
%      Performance = CER_Outp(1:499,:)'; %'
      Performance = CER_Outp(size(CER_Outp,1)-299:size(CER_Outp,1),:)'; %'
    else
      Performance = CER_Outp'; %'
    end
  end
  plot1=plot(1:size(Performance,2),Performance);
%  LastOnes=Performance(:,390:size(Performance,2))
  legend('signal','ctx-contr','ec-contr','hip-contr','s-c', 'c-c','ec-c','h-c');
  ylabel('av. firing');
  xlabel('time steps');
  x=Performance;
end

if (LookAtLayerOutputs==1)
  SumOutput(:,1) = mean(EC_Outp(:, :),2);
  SumOutput(:,2) = mean(HIP_Outp(:,:),2);
%  SumOutput(:,3) = mean(EC_Outp(:,1:N_CtxtInEC),2);
%  SumOutput(:,3) = mean(EC_Outp(:,N_CtxtInEC+1:N_CtxtInEC+2),2);
%  SumOutput(:,4) = mean(EC_Outp(:,N_CtxtInEC+3:N_CtxtInEC+4),2);
%  SumOutput(:,5) = mean(EC_Outp(:,N_CtxtInEC+5:N_CtxtInEC+6),2);
%  SumOutput(:,6) = mean(EC_Outp(:,N_CtxtInEC+7:N_CtxtInEC+8),2);
  if(LargeTimeScale==1)
    ToPlot = takeoutstimcontrol(Inputs,SumOutput'); % ' transpose
  else
    if(size(SumOutput,1)>299)
      HalfWaySim=size(SumOutput,1)/2;
      ToPlot = SumOutput(1:299,:)'; %'tr
%      ToPlot = SumOutput(HalfWaySim-49:HalfWaySim+100,:)'; %'tr
%      ToPlot = SumOutput(size(SumOutput,1)-149:size(SumOutput,1),:)'; %'tr
    else
      ToPlot = SumOutput'; % ' transpose
    end
  end
  plot2=plot(1:size(ToPlot,2),ToPlot);
  %legend('ec-ctxt','ec-sim','hip-tot', 'ec-cc','ecsc', 'hc');
  legend('ec','hip','ec-a','ec-b','ec-c','ec-d');
  ylabel('av. firing');
  xlabel('time steps');
  x=ToPlot;
end

if (LookAtEndEC==1)
  EndState(1,:) = LYR.NodeAccom(1,:);
  EndState(2,:) = LYR.NodeAct(1,:);
  EndState(3,:) = [LYR.Wgts(:,1)']; % zeros(1,2)]; % 'transpose
  EndState(4,:) = [LYR.Wgts(:,N_CtxtInEC*2+1)']; % zeros(1,2)]; % 'transpose
%  EndState(4,:) = [CTX_Outp(1990,:) zeros(1,2)];
%  EndState(4,:)=EC_Outp(30,:);
  EndState(5,:)=EC_Outp(400,:);
  plot3=plot(1:size(EndState,2),EndState);
  legend('accom','act','wgts to 12', 'stim1','stim2');
  ylabel('av. firing');
  xlabel('cells');
  x=EndState
end

if (LookAtHippPattern==1)
  StableCtxt=floor(HIP_Outp(94,:)+0.95*ones(1,size(HIP_Outp,2)));
  ComplC=ones(1,size(HIP_Outp,2))-StableCtxt;
  StableStim=floor(HIP_Outp(135,:)+0.95*ones(1,size(HIP_Outp,2)));
  ComplS=ones(1,size(HIP_Outp,2))-StableStim;
  for t=1:size(HIP_Outp,1)
     SumPat(t,1)= sum(HIP_Outp(t,:) .* StableCtxt);
     SumPat(t,2)= sum(HIP_Outp(t,:) .* ComplC);
     SumPat(t,3)= sum(HIP_Outp(t,:) .* StableStim);
     SumPat(t,4)= sum(HIP_Outp(t,:) .* ComplS);
%     SumPat(t,4)=posdiffvectors(StableStim,HIP_Outp(t,:));
  end
  if(LargeTimeScale==1)
    HipPlot = takeoutstimcontrol(Inputs,SumPat'); % ' transpose
  else
    if(size(SumPat,1)>299)
      HalfWaySim=size(SumPat,1)/2;
%      HipPlot = SumPat(HalfWaySim-149:HalfWaySim+150,:)'; %'tr
%      HipPlot = SumPat(1:299,:)'; % ' transpose
      HipPlot = SumPat(size(SumPat,1)-299:size(SumPat,1),:)'; % ' transpose
    else
      HipPlot = SumPat'; % ' transpose
    end
  end
  plot4=plot(1:size(HipPlot,2),HipPlot);
  legend('+ctxt-','-ctxt','+sim','-sim');
  ylabel('difference');
  xlabel('time steps');
  x=HipPlot;
end

if (LookAtEndHip==1)
%  EndState(1,:) = LYR.NodeAccom(1,:);
  EndState(1,:) = HIP_Outp(15,:);  % assuming stims each 20t+5 its this is ctct
  EndState(2,:) = HIP_Outp(17,:);  % ... and this is a stim.
  EndState(3,:) = HIP_Outp(32,:);  % ... and this is a dbl stim.
%  EndState(4,:) = HIP_Outp(1420,:);  % ... and this is a dbl stim.
%  EndState(3,:) = LYR.Wgts(1,:);  % ... and this is a dbl stim.
%  EndState(4,:) = LYR.Wgts(N_CtxtInEC*2+1,:);  % ... and this is a dbl stim.
  plot3=plot(1:size(EndState,2),EndState);
  legend('accom','end-act','ctxt-act','stim-act','dble-stim');
  ylabel('av. firing');
  xlabel('cells');
  x=EndState;
end
  

%  save ECMODEL/results/discrim-outp.txt SummaryOutput -ASCII -TABS;



%[X,Y] = meshgrid(1:4, 1:20);
%mesh(X,Y,ResultSummary, 'EdgeColor', 'black');

function [Dif]=posdiffvectors(TestVec,BaseVec);
DifVec=TestVec-BaseVec;
DifVec(find(DifVec<0))=0;
Dif=sum(DifVec);

function [JustStims]=takeoutstims(Inputs,AllTimePoints);
Stim=1;
for t=1:size(AllTimePoints,2)
  if(Inputs(t,size(Inputs,2)-2)>0)
     JustStims(:,Stim)=AllTimePoints(:,t);
     Stim=Stim+1;
  end
end

function [JustStims]=takeoutstimcontrol(Inputs,AllTimePoints);
Stim=1;
for t=1:size(AllTimePoints,2)
  if(sum(Inputs(t,size(Inputs,2)-2:size(Inputs,2)-1))>0)
     JustStims(1:size(AllTimePoints,1),Stim)=AllTimePoints(:,t);
     JustStims(size(AllTimePoints,1)+1:2*size(AllTimePoints,1),Stim)=AllTimePoints(:,t-1);
     Stim=Stim+1;
  end
end
