function [Code] = ecplus1(SomeIndex);

% Iterates through a series of N-length input vectors generated in a sub &  
% produces one M-length output vector per input vector.
% Martijn Meeter, m@meeter.nl, taking a Jeevan Kalanithi files as basis 
% Began March 2003

% EC,HIP & CER are structs that contains all its relevant info. Arrays 
% defined & initialized in initialize_xx, Layer sizes & learnrates set there
% ---------------------------------------------------
% XX.Wgts -- N_Inp*N_Node array; each vector is wgts to 1 EC granule.
% XX.WgtMax --  N_Inp*N_Node array; each entry is max value attainable by wgt
% XX.NodeAct,NodeAccom,NodeOutp -- 1 * N_Node arrays.  Each entry contains
%   relevant val for one principal node

RepliNum=1
rand('state',sum(100*clock))
SIMUL = 'recall' % simulation done. Can be 'famil', 'recall', 'discrim', 'blocking', 'latinh', 'latinh-ctrl', 'latinh-ctxt', 'l-irrel', 'sens-precon', 'ctxtchange', 'extin', 'neg-pat', or...

for Repli=1:RepliNum

[Inputs, N_TIMESTEPS,N_INPUTS] = generate_inputs(SIMUL);
EC = initialize_ec(1,N_INPUTS);
HIP = initialize_hip(1, EC);
CER = initialize_cer(1,Inputs,EC,HIP);
%Pre=CER.CerWgts;
EC_Outp = zeros(N_TIMESTEPS, EC.N_Node);
HIP_Outp =zeros(N_TIMESTEPS, HIP.N_Node);
CER_Outp =zeros(N_TIMESTEPS, CER.N_Outp+3);

for t = 1:N_TIMESTEPS
  text = 'One iteration';
  [EC, EC_Outp(t,:)] = iterate_lyr(EC, Inputs(t,:),t);
  [HIP, HIP_Outp(t,:)]=iterate_lyr(HIP, EC.NodeOutp,t);
  if t<N_TIMESTEPS,CER.Target=Inputs(t+1,N_INPUTS);,end
  [CER, CER_Outp(t,:)]=iterate_cer(CER,Inputs(t,:),EC.NodeOutp,HIP.NodeOutp,t);
  if(abs(CER.Target-CER.Outp)>0.5),Error=abs(CER.Target-CER.Outp)-0.5;,else,Error=0;,end 
  [HIP,ACH]=learn_with_ach(HIP, EC.NodeOutp,Error,1,t);
%  if(t==1835) | (t==3835) Change=(CER.CerWgts-Pre)';  end
end

%EC_Outp(35,16)

if strcmp(SIMUL,'blocking')|strcmp(SIMUL,'sens-precon'),KeyBlock=[CER_Outp(1995,:); CER_Outp(2015,:); CER_Outp(3975,:); CER_Outp(3995,:)],end

%if strcmp(SIMUL,'recall'),Results = calculate_output(SIMUL,HIP_Outp);,end
x=complex_output(SIMUL,Inputs,EC_Outp,HIP_Outp,CER_Outp,HIP);

if (RepliNum>1)
     for i=1:size(x,1)
       Results((i-1)*size(x,2)+1:i*size(x,2),Repli)=x(i,:)'; %'transpose
     end
end

end % END OF LOOP FOR REPLICATIONS

x(1,1,1)

if (RepliNum>1)
     save results\replis-output-vu.txt Results -ASCII -TABS;
end

Code=1;