function [Inputs, N_TimeSteps, N_Inp] = generate_inputs(SIMULATION);

% generate_inputs creates a variety of inputs for the model.
% The INPUTS vector of input arrays can be initialized in several ways
% Way #1 is to make top half the permanent ctxt & bottom half a stimulus

N_CTXT = 15; %round(N_Inp*0.5);
N_Inp=N_CTXT*2+3;  % 2 ctxts of 5, 2 stim, 1 US

if strcmp(SIMULATION,'famil')
  text = 'constant context with discrete stimulus on-off twice'
  N_TimeSteps = 140;  % Duration of simulation
  N_Stim = 1;    % Stimulus size in nodes
  StimDur = 5;   % Stimulus duration

%  Inputs = createfluctctxt(N_TimeSteps, N_Inp, N_CTXT,1);
  Inputs = createconstantctxt(N_TimeSteps, N_Inp, N_CTXT,1);
  Inputs = addstim(Inputs, 35, StimDur, N_CTXT+1, N_CTXT+N_Stim);
  Inputs = addstim(Inputs, 135, StimDur, N_CTXT+1, N_CTXT+N_Stim);
end

if strcmp(SIMULATION,'recall')
  text = 'constant context on-off twice, two times stim'
  N_TimeSteps = 35;
  N_Stim = 5;
  StimDur = 5;

  OffSet=5
  Inputs = createconstantctxt(N_TimeSteps, N_Inp, 10,1);
  Inputs = addstim(Inputs, 16, StimDur, N_CTXT+1, N_CTXT+N_Stim);
  Inputs = addstim(Inputs, 31, StimDur, N_CTXT+1+OffSet, N_CTXT+N_Stim+OffSet);
%  Inputs = addreset(Inputs,N_Inp,20);
end

if strcmp(SIMULATION,'mixedpat')
  text = 'constant context w. 2 patterns & one halfpattern'
  N_TimeSteps = 47;
  N_Stim = 6;
  StimDur = 5;

  OffSet=0
  Inputs = createconstantctxt(N_TimeSteps, N_Inp, 10,1);
  Inputs = addstim(Inputs, 16, StimDur, N_CTXT+1, N_CTXT+N_Stim);
  Inputs = addstim(Inputs, 31, StimDur, N_CTXT+N_Stim+1, N_CTXT+N_Stim*2);
  Inputs = addstim(Inputs, 46, 1, N_CTXT+1+OffSet, N_CTXT+N_Stim+OffSet);
end

if strcmp(SIMULATION,'assocrecog')
  text = 'constant context w. 2 patterns & one remixed pattern'
  N_TimeSteps = 47;
  N_Stim = 6;
  StimDur = 5;

  OffSet=0
  Inputs = createconstantctxt(N_TimeSteps, N_Inp, N_CTXT,1);
  Inputs = addstim(Inputs, 16, StimDur, N_CTXT+1, N_CTXT+N_Stim);
  Inputs = addstim(Inputs, 31, StimDur, N_CTXT+N_Stim+1, N_CTXT+N_Stim*2);
  Inputs = addstim(Inputs, 46, 1, N_CTXT+1+OffSet, N_CTXT+N_Stim/2+OffSet);
  Inputs = addstim(Inputs, 47, 1, N_CTXT+1+OffSet, N_CTXT+N_Stim+OffSet);
end

if strcmp(SIMULATION,'discrim')
  text='constant context, one stim presented with air puff each 20 its'
  N_TimeSteps =997;
  N_Stim=1;
  StimDur = 1; % stimulus duration

  Inputs = createconstantctxt(N_TimeSteps, N_Inp, N_CTXT,1);
%  Inputs = createfluctctxt(N_TimeSteps, N_Inp, N_CTXT,1);
  for StimT=1:49
    Inputs =addstimUS(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
  end
end

if strcmp(SIMULATION,'ctxtchange')
  text='A=airpuff 30 trial in X, then test in Y context'
  N_TimeSteps =640; % X to 1980, trials at 1965 and 2005
  N_Stim=1;
  StimDur = 1; % stimulus duration

  Inp1 = createconstantctxt(600, N_Inp, N_CTXT,1);
  Inp2 = createconstantctxt(40, N_Inp, N_CTXT,2);
  Inputs = [Inp1; Inp2];
  for StimT=1:29
    Inputs =addstimUS(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
  end
  Inputs =addstimUS(Inputs,635, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
end

if strcmp(SIMULATION,'blocking')
  text='constant ctxt, stim A+airpuff 200 trials, then A+B+air 200, then B'
  N_TimeSteps =3999;
  N_Stim=1;
  StimDur = 1; % stimulus duration

  Inputs = createconstantctxt(N_TimeSteps, N_Inp, N_CTXT,1);
  for StimT=1:99
    Inputs =addstimUS(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
  end
  for StimT=100:198
    Inputs = addstimUS(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+2);
  end
  Inputs = addstimUS(Inputs, 199*20+15, StimDur, N_CTXT*2+2, N_CTXT*2+2);
end

if strcmp(SIMULATION,'sens-precon')
  text='A+B, stim A+airpuff 200 trials, then B'
  N_TimeSteps =3999;
  N_Stim=1;
  StimDur = 1; % stimulus duration

  Inputs = createconstantctxt(N_TimeSteps, N_Inp, N_CTXT,1);
  for StimT=1:99
    Inputs =addstim(Inputs,StimT*20+15, StimDur, N_CTXT*2+1,N_CTXT*2+N_Stim*2);
  end
  for StimT=100:198
    Inputs =addstimUS(Inputs,StimT*20+15, StimDur, N_CTXT*2+1,N_CTXT*2+N_Stim);
  end
  Inputs = addstim(Inputs, 199*20+15, StimDur, N_CTXT*2+1+N_Stim, N_CTXT*2+N_Stim*2);
end

if strcmp(SIMULATION,'latinh')
  text='stim A 100 trials, then A+airpuff 100'
  N_TimeSteps =3999;
  N_Stim=1;
  StimDur = 1; % stimulus duration

  Inputs = createconstantctxt(N_TimeSteps, N_Inp, N_CTXT,1);
  for StimT=1:99
    Inputs = addstim(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
  end
  for StimT=100:199
   Inputs = addstimUS(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
  end
end

if strcmp(SIMULATION,'latinh-ctrl')
  text='ctxt 100 trials, then A+airpuff 100'
  N_TimeSteps =3999;
  N_Stim=1;
  StimDur = 1; % stimulus duration

  Inputs = createconstantctxt(N_TimeSteps, N_Inp, N_CTXT,1);
  for StimT=100:199
    Inputs =addstimUS(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
  end
end

if strcmp(SIMULATION,'l-irrel')
  text='stim A & airpuff 100 trials, then A+airpuff 100'
  N_TimeSteps =3999;
  N_Stim=1;
  StimDur = 1; % stimulus duration

  Inputs = createconstantctxt(N_TimeSteps, N_Inp, N_CTXT,1);
  for StimT=1:99
    Inputs = addUS(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
    Inputs = addstim(Inputs,StimT*20+25, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
  end
  for StimT=100:199
   Inputs = addstimUS(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
  end
end

if strcmp(SIMULATION,'latinh-ctxt')
  text='A in X 100 trials, then A+airpuff in Y 100'
  N_TimeSteps =3999;
  N_Stim=1;
  StimDur = 1; % stimulus duration

  Inp1 = createconstantctxt(2000, N_Inp, N_CTXT,1);
  Inp2 = createconstantctxt(1999, N_Inp, N_CTXT,2);
  Inputs = [Inp1; Inp2];
  for StimT=1:100
    Inputs = addstim(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
  end
  for StimT=101:199
    Inputs =addstimUS(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
  end
end

if strcmp(SIMULATION,'extin')
  text='A+airpuff 100 trial in X, A 100 trials in Y, then test in X'
  N_TimeSteps =4010; % X to 1970, trials at 1965 and 2005
  N_Stim=1;
  StimDur = 1; % stimulus duration

  Inp1 = createconstantctxt(2000, N_Inp, N_CTXT,1);
  Inp2 = createconstantctxt(1980, N_Inp, N_CTXT,2);
  Inp3 = createconstantctxt(30, N_Inp, N_CTXT,1);
  Inputs = [Inp1; Inp2; Inp3];
  for StimT=1:100
    Inputs=addstimUS(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
  end
  for StimT=101:198
    Inputs=addstim(Inputs,StimT*20+15, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
  end
  Inputs =addstimUS(Inputs,4005, StimDur, N_CTXT*2+1, N_CTXT*2+N_Stim);
end

if strcmp(SIMULATION,'neg-pat')
  text='A+B no air puff, A+puff, B+puff, each 100 trials'
  N_TimeSteps =14999;
  N_Stim=1;
  StimDur = 1; % stimulus duration

  Inputs = createconstantctxt(N_TimeSteps, N_Inp, N_CTXT,1);
  for StimT=1:249
    Inputs =addstimUS(Inputs,StimT*60+15, StimDur, N_CTXT*2+1,N_CTXT*2+N_Stim);
    Inputs =addstimUS(Inputs,StimT*60+35, StimDur, N_CTXT*2+N_Stim+1,N_CTXT*2+N_Stim*2);
    Inputs =addstim(Inputs,StimT*60+55, StimDur, N_CTXT*2+1,N_CTXT*2+N_Stim*2);
  end
end


function [Inputs] = createconstantctxt(N_Time,N_Inp,N_Ctxt,Ctxt)
% Start from an empty matrix, fill the Ctxt-ed N_CTXT elements with 0.5s
Inputs = zeros(N_Time, N_Inp);
Inputs(:, (Ctxt-1)*N_Ctxt+1: Ctxt*N_Ctxt) = 0.5*ones(N_Time, N_Ctxt);

function [Inputs] = addreset(Inputs,N_Inp,T)
% The following line produces a line of 0s that resets the model
Inputs(T,:) = zeros(1, N_Inp);

function [Inputs] = addstim(Inputs,T,D,StartNode,EndNode)
% Creates a stimulus of D duration from time T on, ending with a US. 
Inputs(T:T+D-1,StartNode:EndNode)= 0.5*ones(D,EndNode-StartNode+1);

function [Inputs] = addstimUS(Inputs,T,D,StartNode,EndNode)
% Creates a stimulus of D duration from time T on, ending with a US
Inputs(T:T+D-1,StartNode:EndNode)= 0.5*ones(D,EndNode-StartNode+1);
Inputs(T+D,size(Inputs,2))= 1;

function [Inputs] = addUS(Inputs,T,D,StartNode,EndNode)
% Creates US at t T+D. Really week stim put before that to let outp.-anal pick it up
Inputs(T:T+D-1,StartNode:EndNode)= 0.0001*ones(D,EndNode-StartNode+1);
Inputs(T+D,size(Inputs,2))= 1;

function [Inputs] = createfluctctxt(N_Time,N_Inp,N_Ctxt,Ctxt)
% Start from an empty matrix, fill the Ctxt-ed N_CTXT elements with a random half 0.5s and half 0s
CtxtMTranspose = [ones(N_Ctxt/2,N_Time); zeros(N_Ctxt*1/2,N_Time)];
CtxtM= CtxtMTranspose(permutmatrixvert(N_Ctxt, N_Time))'; %'
if (Ctxt==1)
     Inputs = 0.5*[CtxtM zeros(N_Time,N_Inp-N_Ctxt)];
else
  Inputs=0.5*[zeros(N_Time,(Ctxt-1)*N_Ctxt) CtxtM zeros(N_Time,N_Inp-Ctxt*N_Ctxt)]
end

function [Permut] = permutmatrixvert(dim1,dim2)
for i=1:dim2
  Permut(:,i)=randperm(dim1)'; %'p
end
