function [EC]=initialize_ec(INIT_EC_WGTS,N_INPUTS);

% Creates and initializes the EC struct. All EC params set here

EC.N_Inp = N_INPUTS;
EC.N_Node = N_INPUTS; %odefault 25
EC.LTP = 0.01; %in conditsims: 0.01, in familsim .1
EC.LTD = 0.5*EC.LTP; %default 0.5*LTP
EC.WgtStasis = 0.025;
EC.WgtDecay = 0;
EC.FfwdInhib = EC.WgtStasis*1.75;
EC.FbInhib= 0; %EC.FfwdInhib;

EC.WgtConst = 1.9 *eye(EC.N_Inp,EC.N_Node); % strong immutable Wgts
%EC.WgtConst(21,24)=2;  % xtra support for stim.
EC.WgtMax = 1.5*(ones(EC.N_Inp, EC.N_Node)-0.5*EC.WgtConst); % strong wgts no learn
%EC.WgtMax(1:20,:)=EC.WgtMax(1:20,:); % From ctxtnodes stronger wgts
RndPercentage=0.5*rand(EC.N_Inp, EC.N_Node)+0.75*ones(EC.N_Inp, EC.N_Node);
EC.Wgts = (EC.WgtStasis*RndPercentage) .* EC.WgtMax;

EC.NodeAct = zeros(1,EC.N_Node);
EC.NodeAccom = zeros(1,EC.N_Node);
EC.NodeOutp = zeros(1,EC.N_Node);