function [HIP]=initialize_hip(HIP_YES,EC);

% Creates and initializes the HIP struct. All HIP params set here
% No role yet found for HIP_YES.
% Args after HIP_YES are structs carrying input modules of the HIP module

HIP.N_Inp = EC.N_Node;
HIP.N_Node = 40; % EC.N_Node;
HIP.LTP = 0.05;
HIP.LTD = 0.5*HIP.LTP;
HIP.WgtStasis = 0.27;
MaxWgt=1.1;
HowMany=floor(HIP.N_Inp*.85);
HIP.WgtDecay = 0;
HIP.FfwdInhib = HIP.WgtStasis * MaxWgt * HowMany/HIP.N_Inp*1.2;
HIP.FbInhib = 0; %HIP.FfwdInhib/1.2;

HIP.WgtConst = zeros(HIP.N_Inp, HIP.N_Node);
% Rnd half of weights is created, which max strength MaxWgt
NumWgts=[ones(HowMany, HIP.N_Node); zeros(HIP.N_Inp-HowMany, HIP.N_Node)];
PermutExist=NumWgts(permutmatrixvert(HIP.N_Inp,HIP.N_Node));
HIP.WgtMax = MaxWgt * PermutExist;
RndStrength=0.2*rand(HIP.N_Inp, HIP.N_Node)+0.9*ones(HIP.N_Inp, HIP.N_Node);
HIP.Wgts = (HIP.WgtStasis*RndStrength) .* HIP.WgtMax;

HIP.NodeAct = zeros(1,HIP.N_Node);
HIP.NodeAccom = zeros(1,HIP.N_Node);
HIP.NodeOutp = zeros(1,HIP.N_Node);

function [Permut] = permutmatrixvert(dim1,dim2)
for i=1:dim2
  Permut(:,i)=randperm(dim1)'; %'p
end