function [CER,Output] = iterate_cer(CER,CTXInput,ECInput,HIPInput,target, t);

% iterate_lyr takes an input vector of N_Inp and transforms it via act &
% learning fxns.It computes what the layer looks like, and a matrix
% representing principal cell output.  It processes JUST ONE input.

if(sum(CTXInput)==0)
   CER.NodeAct=zeros(1,CER.N_Node);
   CER.Outp=zeros(1,CER.N_Outp);
   CER.Target=zeros(1,CER.N_Outp);
   CerPartialOutp=zeros(1,3);
else

% compute act of input layer
Nn=CER.N_Node;
CER.NodeAct( 1, 1:Nn/3 )  = CTXInput* CER.CtxWgts;
CER.NodeAct(1,Nn/3+1:2*Nn/3)=ECInput * CER.EcWgts;
CER.NodeAct(1,2*Nn/3+1:Nn) = HIPInput* CER.HipWgts;

% compute outp
CER.Outp = CER.NodeAct*CER.CerWgts;
%if(CER.Outp>1),CER.Outp=1;,end
%if(CER.Outp<0),CER.Outp=0;,end
ERROR = CER.Target-CER.Outp;
CerPartialOutp=[CER.NodeAct(1,1:Nn/3)*CER.CerWgts(1:Nn/3,CER.N_Outp) CER.NodeAct(1,Nn/3+1:2*Nn/3)*CER.CerWgts(Nn/3+1:2*Nn/3,CER.N_Outp) CER.NodeAct(1,2*Nn/3+1:Nn)*CER.CerWgts(2*Nn/3+1:Nn,CER.N_Outp)];
% learning with delta rule
CER.CerWgts=CER.CerWgts + (CER.Alpha * ERROR * CER.NodeAct'); %'delta rule

end

Nn=CER.N_Node;
Output = [CER.Outp CerPartialOutp];