function [LYR,Output] = iterate_lyr(LYR, Input, t);

% iterate_lyr takes an input vector of N_Inp and transforms it via act &
% learning fxns.It computes what the layer looks like, and a matrix
% representing principal cell output.  It processes JUST ONE input.

if(sum(Input)==0)
   LYR.NodeAccom=zeros(1,LYR.N_Node);
   LYR.NodeAct=zeros(1,LYR.N_Node);
   LYR.NodeOutp=zeros(1,LYR.N_Node);
else

% compute accomodation (with Outp of previous iteration)
LYR.NodeAccom = 0.9 * LYR.NodeAccom + 0.5*LYR.NodeAct;

% compute activation (with Accom of this iteration)
Inhib = LYR.FfwdInhib*sum(Input)+LYR.FbInhib*sum(LYR.NodeOutp);
LYR.NodeAct = (Input*LYR.Wgts+Input*LYR.WgtConst-Inhib) .* (ones(1,LYR.N_Node)-0.9*LYR.NodeAccom);
LYR.NodeAct(find(LYR.NodeAct<0))=0;
LYR.NodeAct(find(LYR.NodeAct>1))=1;
%if(ACH_Modul==1),Inhib,end

% compute output (act above threshold; all below threshold set to 0)
% if outp should start at 0.1: LYR.nodeOutp(find(LYR.NodeAct<0.1))=0;
LYR.NodeOutp = LYR.NodeAct;
%LYR.NodeOutp(find(LYR.NodeOutp>1))=1;

% learning. For learning, a higher threshold is used (NMDA threshold)
NmdaOutp = LYR.NodeAct - (0.4)*ones(1,LYR.N_Node);
NmdaOutp(find(NmdaOutp<0))=0;
LYR.Wgts=LYR.Wgts + (LYR.LTP* Input'*NmdaOutp) .* (LYR.WgtMax-LYR.Wgts) - (LYR.LTD*(ones(1,LYR.N_Inp)-Input)'*NmdaOutp).*LYR.Wgts;

% Weights can also be made to decay back to default vals.
if(LYR.WgtDecay>0)
   LYR.Wgts = (1-0.0001)* (LYR.WgtStasis*LYR.WgtMax - LYR.Wgts);
end

end % belongs to check on whether model must be reset

Output = LYR.NodeOutp;
