function [LYR,ACh] = learn_with_ach(LYR, Input, US, Novelty_ACh, t);

% learn_with_ach takes as input an input vector and a layer, a scalar US giving
% the prediction error for the US, and an index Novelty_ACh that specifies
% whether novelty should affect learning (1) or not (0). it assumes that
% updating of activity and normal learning have been done, and does the
% boosted learning associated with either no layer-act or presence of a US

if(sum(Input)==0)
  %No learning if there has been a reset
  LYR.NodeAct=zeros(1,LYR.N_Node);
  ACh=0;
else

% Recompute activity without truncating
Inhib = LYR.FfwdInhib*sum(Input)+LYR.FbInhib*sum(LYR.NodeOutp);
NodeAct = (Input*LYR.Wgts+Input*LYR.WgtConst-Inhib) .* (ones(1,LYR.N_Node)-0.45*LYR.NodeAccom);

ACh=0;
if(US>0)
  ACh=US*1.5;
end

if(Novelty_ACh==1)
   % Find out if there is enough act; else boost ACh
   HighFirers=floor(NodeAct + 0.96*ones(1,LYR.N_Node));
  HighFirers(find(HighFirers<0))=0;
  if (sum(HighFirers)<LYR.N_Node*0.1),ACh=15;,end
  if(ACh>1),AChBoostAt=t,end
end

if (ACh>0)
%  NodeAct = (Input*LYR.Wgts+Input*LYR.WgtConst);
  OrderedAct=order(NodeAct);
  Threshold=OrderedAct(1,0.15*LYR.N_Node)-0.000001;
  Winners=floor(NodeAct + (1-Threshold)*ones(1,LYR.N_Node));
  Winners(find(Winners<0))=0;

  % learning. For learning, a higher threshold is used (NMDA threshold)
  PosLearn=ACh*Input'*Winners .* (LYR.WgtMax-LYR.Wgts);
  PosLearn(find(PosLearn>0.3))=0.30;
  NegLearn=0.5*ACh*(ones(1,LYR.N_Inp)-Input)'*Winners.*LYR.Wgts;
  NegLearn(find(NegLearn>0.25))=0.25;  
  LYR.Wgts=LYR.Wgts +PosLearn  -NegLearn ;
end

end % belongs to check on whether model must be reset


function [ToOrder]=order(ToOrder)
for i=1:size(ToOrder,2)-1
  for j=i+1:size(ToOrder,2)
    if (ToOrder(1,j)>ToOrder(1,i))
      Temp=ToOrder(1,j);
      ToOrder(1,j)=ToOrder(1,i);
      ToOrder(1,i)=Temp;
    end
  end
end